var Conversation = new Class({
	owner: null,
  el: null,
	el_input: null,
	el_message_prototype: null,
	id_user: null,
	window: null,
	native_window: null,
	messages: new Array(),
	options: {width: 700, height: 500},
	server: null,
  
  initialize: function(o, id_user){
		this.owner = o;
		this.id_user = id_user;
		
		this.server = new Server({silent: true});
		
		var tpl = new Template("message");    
		this.el_message_prototype = new Element('div').adopt(tpl.xml).getFirst();
		
		var t = this;
		var title = "CLIM - " + this.owner.user.contacts.get(id_user).nick;
		
		// create new window
		this.window = window.open("conversation.html", title, "height=" + this.options.height + ", width=" + this.options.width);
		this.native_window = this.window.nativeWindow;
		
		this.window.document.title = title;
		this.window.opener = this;
		
		// assign onClose event
		this.native_window.addEventListener(air.Event.CLOSE, function(){t.onClose();});
  },
	
	//activate and show the new conversation window 
	open: function(){
	  this.native_window.activate(); 
	},
	
	close: function(){
		this.native_window.close();
	},
	
	// raised when new conversation window was opened
	onLoad: function(){
		this.el = $(this.window.document.body.getElement('div#_main'));
		this.el_input = this.el.getElementById('input_text');
		
		var t = this;
		this.el_input.addEvent('keydown', function(e){
			var event = new Event(e);
			if(e.key == 'enter'){
				event.stop();
				if(!e.control){
					t.submit();
					
				} else {
					this.value += '\n';
					this.selectionStart = this.value.length;
					this.selectionEnd = this.selectionStart;					
				}
			}
		});
		
		this.reload();
		this.el_input.focus();
	},
	
	// end the conversation when user closes the window
	onClose: function(){
		this.owner.user.endConversation(this.id_user);
	},
	
	reload: function(){
		if(!$defined(this.el)) return;
		var t = this;
		this.messages.each(function(value, key){
			if($defined(value.shown) && value.shown) return;
			
			// zkopirujeme prototyp spravy
			var el = t.el_message_prototype.clone(true, true);			
			
			// naplnime spravu
			var time = new DateTime(value.time);
			
			if (value.type == 'sent') {
	  		el.getElement('span.nick').set('html', t.owner.user.info.nick);
		  } else {
		  	el.getElement('span.nick').set('html', t.owner.user.contacts.get(value.id_user).nick);
		  }
			el.getElement('span.time').set('html', time.format());
			el.getElement('div.body').set('html', value.text.replace(/\r?\n/g, '</br>'));
			
			t.el.getElement('#messages_panel').adopt(el);
			
			t.messages[key].shown = true;
		});
	},
	
	// send message
	submit: function(){
		var text = this.el_input.value;
		
		// odstranime nepotrebne konce riadkov a entery (len aby sme zistili ci potom neostane prazdny text)
		var test_text = text.replace(/\n|\0|\f|\r|\t|\v| /gm, "");
		if(test_text == '') return;
		this.el_input.value = '';
		
		var t = this;
    this.server.request({'action': 'send_message', 'args': {'text': text, 'id_user_contact': this.id_user}}, function(response){
      if(!$defined(response)){
        alert('Chyba: nepodarilo sa odoslať správu');
				if(t.el_input.value == '') t.el_input.value = text;
				
      } else {        
				// response should be the submit time in seconds
				if(!$empty(response)){
					t.messages.push({'type': 'sent', 'id_user': t.id_user, 'text': response.text, 'time': response.time});
					t.reload();
				}
      }
    });
	}
});

Conversation.implement(new Events);